Ext.define("Ext.google.ux.Client",{extend:"Ext.Mixin",mixins:["Ext.mixin.Mashup"],requiredScripts:["//apis.google.com/js/client.js?onload=_ext_google_ux_client_initialize_"],statics:{getApiVersion:function(b){var a=this.libraries[b];return a&&a.state==2?a.version:null}},mixinConfig:{extended:function(c,a,b){this.load(b.googleApis)}},onClassMixedIn:function(a){this.load(a.prototype.googleApis)},privates:{statics:{initialized:false,blocked:false,loading:0,libraries:{},load:function(d){var c=this.libraries,a,b;if(!Ext.isObject(d)){return}Ext.Object.each(d,function(f,e){a=e.version||"v1";b=c[f];if(!Ext.isDefined(b)){c[f]={version:a,state:0}}else{if(b.version!==a){Ext.log.error('Google API: failed to load version "'+a+'" of the','"'+f+'" API: "'+b.version+'" already loaded.')}}});this.refresh()},refresh:function(){var a=this;if(!a.blocked){Ext.env.Ready.block();a.blocked=true}if(!a.initialized){return}Ext.Object.each(a.libraries,function(c,b){if(b.state==0){b.state=1;gapi.client.load(c,b.version,function(){b.state=2;if(!--a.loading){a.refresh()}})}if(b.state==1){a.loading++}});if(!a.loading&&a.blocked){Ext.env.Ready.unblock();a.blocked=false}},initialize:function(){this.initialized=true;this.refresh()}}}});_ext_google_ux_client_initialize_=function(){gapi.auth.init(function(){Ext.google.ux.Client.initialize()})};Ext.define("Ext.google.data.AbstractProxy",{extend:"Ext.data.proxy.Server",mixins:["Ext.google.ux.Client"],batchActions:false,reader:{type:"json",rootProperty:"items",messageProperty:"error"},doRequest:function(a){var d=this,c=d.buildRequest(a),e=d.getWriter(),b=false;if(e&&a.allowWrite()){c=e.write(c)}d.execute(d.buildApiRequests(c)).then(function(f){d.processApiResponse(a,c,f)});return c},buildUrl:function(a){return""},privates:{execute:function(b){b=[].concat(b);var a=[];return Ext.Array.reduce(b,function(d,c){return d.then(function(){return c.then(function(e){a.push(e)})})},Ext.Deferred.resolved()).then(function(){return{result:a}})},processApiResponse:function(a,d,e){var b=false,c=[];Ext.each(Object.keys(e.result),function(g){var f=e.result[g].result;if(f.error){b=f.error.message;return false}c.push(f)});this.processResponse(true,a,d,{results:b?[]:c,success:!b,error:b})},sanitizeItems:function(a){var b=[],c=[];Ext.Array.each(a,function(d){if(!Ext.Array.contains(c,d.id)){b.push(d);c.push(d.id)}},this,true);return b}}});Ext.define("Ext.google.data.EventsProxy",{extend:"Ext.google.data.AbstractProxy",alias:"proxy.google-events",googleApis:{calendar:{version:"v3"}},buildApiRequests:function(b){var a=this,c=b.getAction();switch(c){case"read":return a.buildReadApiRequests(b);case"create":return a.buildCreateApiRequests(b);case"update":return a.buildUpdateApiRequests(b);case"destroy":return a.buildDestroyApiRequests(b);default:Ext.raise("unsupported request: events."+c);return null}},extractResponseData:function(b){var c=this,d=c.callParent(arguments),a=[];Ext.each(d.results,function(e){switch(e.kind){case"calendar#events":a=a.concat(e.items.map(c.fromApiEvent.bind(c)));break;case"calendar#event":a.push(c.fromApiEvent(e));break;default:break}});return{items:c.sanitizeItems(a),success:d.success,error:d.error}},privates:{toApiEvent:function(c,b){var a={};Ext.Object.each(c,function(e,g){var f=null,d=null;switch(e){case"calendarId":case"description":a[e]=g;break;case"id":a.eventId=g;break;case"title":a.summary=g;break;case"startDate":case"endDate":if(b){d=new Date(g);d.setHours(0,-d.getTimezoneOffset());d=Ext.Date.format(d,"Y-m-d")}else{f=Ext.Date.format(new Date(g),"c")}a[e.slice(0,-4)]={date:d,dateTime:f};break;default:break}});return a},fromApiEvent:function(b){var a={allDay:true};Ext.Object.each(b,function(d,f){var c,g,e;switch(d){case"id":case"description":a[d]=f;break;case"summary":a.title=f;break;case"start":case"end":c=Ext.Date.parse(f.dateTime||f.date,"C");g=c.getTimezoneOffset();e=!!f.date;if(e&&g!==0){c.setHours(0,-g)}a[d+"Date"]=c;a.allDay=a.allDay&&e;break;default:break}});return a},buildReadApiRequests:function(d){var b=d.getParams(),f=new Date(b.startDate),a=new Date(b.endDate),e=[],c;while(f<a){c=Ext.Date.add(f,Ext.Date.MONTH,3);if(c>a){c=a}e.push(gapi.client.calendar.events.list({calendarId:b.calendar,timeMin:Ext.Date.format(f,"C"),timeMax:Ext.Date.format(c,"C"),singleEvents:true,maxResults:2500}));f=c}return e},buildCreateApiRequests:function(b){var a=b.getRecords()[0];return gapi.client.calendar.events.insert(this.toApiEvent(b.getJsonData(),a.get("allDay")))},buildUpdateApiRequests:function(d){var a=d.getRecords()[0],f=this.toApiEvent(d.getJsonData(),a.get("allDay")),c=a.getModified("calendarId"),e=a.get("calendarId"),b=a.getId(),g=[];f.calendarId=e;f.eventId=b;if(c&&c!==e){g.push(gapi.client.calendar.events.move({destination:e,calendarId:c,eventId:b}))}if(Object.keys(f).length>2){g.push(gapi.client.calendar.events.patch(f))}return g},buildDestroyApiRequests:function(b){var a=b.getRecords()[0];data=b.getJsonData();data.calendarId=data.calendarId||a.get("calendarId")||a.getPrevious("calendarId");return gapi.client.calendar.events["delete"]({calendarId:data.calendarId,eventId:data.id})}}});Ext.define("Ext.google.data.CalendarsProxy",{extend:"Ext.google.data.AbstractProxy",alias:"proxy.google-calendars",requires:["Ext.google.data.EventsProxy"],googleApis:{calendar:{version:"v3"}},buildApiRequests:function(b){var a=this,c=b.getAction();switch(c){case"read":return a.buildReadApiRequests(b);case"update":return a.buildUpdateApiRequests(b);default:Ext.raise("unsupported request: calendars."+c);return null}},extractResponseData:function(b){var c=this,d=c.callParent(arguments),a=[];Ext.each(d.results,function(e){switch(e.kind){case"calendar#calendarList":a=a.concat(e.items.map(c.fromApiCalendar.bind(c)));break;default:break}});return{items:c.sanitizeItems(a),success:d.success,error:d.error}},privates:{toApiCalendar:function(b){var a={};Ext.Object.each(b,function(c,d){switch(c){case"id":a.calendarId=d;break;case"hidden":a.selected=!d;break;default:break}});return a},fromApiCalendar:function(b){var a={hidden:!b.selected,editable:false,eventStore:{autoSync:true,proxy:{type:"google-events",resourceTypes:"events"}}};Ext.Object.each(b,function(c,d){switch(c){case"id":case"description":a[c]=d;break;case"backgroundColor":a.color=d;break;case"summary":a.title=d;break;case"accessRole":a.editable=(d=="owner"||d=="writer");break;default:break}});return a},buildReadApiRequests:function(a){return gapi.client.calendar.calendarList.list()},buildUpdateApiRequests:function(a){var b=this.toApiCalendar(a.getJsonData());return gapi.client.calendar.calendarList.patch(b)}}});Ext.define("Ext.ux.google.Api",{mixins:["Ext.mixin.Mashup"],requiredScripts:["//www.google.com/jsapi"],statics:{loadedModules:{}},onClassExtended:function(c,d,a){var e=a.onBeforeCreated,b=this;a.onBeforeCreated=function(q,j){var n=this,k=[],o=Ext.Array.from(j.requiresGoogle),m=b.loadedModules,g=0,p=function(){if(!--g){e.call(n,q,j,a)}Ext.env.Ready.unblock()},l,h,f;f=o.length;for(h=0;h<f;++h){if(Ext.isString(l=o[h])){k.push({api:l})}else{if(Ext.isObject(l)){k.push(Ext.apply({},l))}}}Ext.each(k,function(t){var r=t.api,i=String(t.version||"1.x"),s=m[r];if(!s){++g;Ext.env.Ready.block();m[r]=s=[p].concat(t.callback||[]);delete t.api;delete t.version;if(!window.google){Ext.raise("'google' is not defined.");return false}google.load(r,i,Ext.applyIf({callback:function(){m[r]=true;for(var u=s.length;u-->0;){s[u]()}}},t))}else{if(s!==true){s.push(p)}}});if(!g){e.call(n,q,j,a)}}}});Ext.define("Ext.ux.google.Feeds",{extend:"Ext.ux.google.Api",requiresGoogle:{api:"feeds",nocss:true}});Ext.define("Ext.ux.dashboard.GoogleRssView",{extend:"Ext.Component",requires:["Ext.tip.ToolTip","Ext.ux.google.Feeds"],feedCls:Ext.baseCSSPrefix+"dashboard-googlerss",previewCls:Ext.baseCSSPrefix+"dashboard-googlerss-preview",closeDetailsCls:Ext.baseCSSPrefix+"dashboard-googlerss-close",nextCls:Ext.baseCSSPrefix+"dashboard-googlerss-next",prevCls:Ext.baseCSSPrefix+"dashboard-googlerss-prev",feedUrl:null,scrollable:true,maxFeedEntries:10,previewTips:false,mode:"detail",closeDetailsGlyph:"8657@",prevGlyph:"9664@",nextGlyph:"9654@",detailTpl:'<tpl for="entries[currentEntry]"><div class="'+Ext.baseCSSPrefix+'dashboard-googlerss-detail-header"><div class="'+Ext.baseCSSPrefix+'dashboard-googlerss-detail-nav"><tpl if="parent.hasPrev"><span class="'+Ext.baseCSSPrefix+"dashboard-googlerss-prev "+Ext.baseCSSPrefix+'dashboard-googlerss-glyph">{parent.prevGlyph}</span> </tpl> {[parent.currentEntry+1]}/{parent.numEntries} <span class="'+Ext.baseCSSPrefix+"dashboard-googlerss-next "+Ext.baseCSSPrefix+'dashboard-googlerss-glyph"<tpl if="!parent.hasNext"> style="visibility:hidden"</tpl>> {parent.nextGlyph}</span> <span class="'+Ext.baseCSSPrefix+"dashboard-googlerss-close "+Ext.baseCSSPrefix+'dashboard-googlerss-glyph"> {parent.closeGlyph}</span> </div><div class="'+Ext.baseCSSPrefix+'dashboard-googlerss-title"><a href="{link}" target=_blank>{title}</a></div><div class="'+Ext.baseCSSPrefix+'dashboard-googlerss-author">By {author} - {publishedDate:this.date}</div></div><div class="'+Ext.baseCSSPrefix+'dashboard-googlerss-detail">{content}</div></tpl>',summaryTpl:'<tpl for="entries"><div class="'+Ext.baseCSSPrefix+'dashboard-googlerss"><span class="'+Ext.baseCSSPrefix+'dashboard-googlerss-title"><a href="{link}" target=_blank>{title}</a></span> <img src="'+Ext.BLANK_IMAGE_URL+'" data-index="{#}" class="'+Ext.baseCSSPrefix+'dashboard-googlerss-preview"><br><span class="'+Ext.baseCSSPrefix+'dashboard-googlerss-author">By {author} - {publishedDate:this.date}</span><br><span class="'+Ext.baseCSSPrefix+'dashboard-googlerss-snippet">{contentSnippet}</span><br></div></tpl>',initComponent:function(){var a=this;a.feedMgr=new google.feeds.Feed(a.feedUrl);a.callParent()},afterRender:function(){var a=this;a.callParent();if(a.feedMgr){a.refresh()}a.el.on({click:a.onClick,scope:a});if(a.previewTips){a.tip=new Ext.tip.ToolTip({target:a.el,delegate:"."+a.previewCls,maxWidth:800,showDelay:750,autoHide:false,scrollable:true,anchor:"top",listeners:{beforeshow:"onBeforeShowTip",scope:a}})}},formatDate:function(b){if(!b){return""}b=new Date(b);var a=new Date(),e=Ext.Date.clearTime(a,true),c=Ext.Date.clearTime(b,true).getTime();if(c===e.getTime()){return"Today "+Ext.Date.format(b,"g:i a")}e=Ext.Date.add(e,"d",-6);if(e.getTime()<=c){return Ext.Date.format(b,"D g:i a")}if(e.getYear()===a.getYear()){return Ext.Date.format(b,"D M d \\a\\t g:i a")}return Ext.Date.format(b,"D M d, Y \\a\\t g:i a")},getTitle:function(){var a=this.data;return a&&a.title},onBeforeShowTip:function(c){if(this.mode!=="summary"){return false}var b=c.triggerElement,a=parseInt(b.getAttribute("data-index"),10);c.maxHeight=Ext.Element.getViewportHeight()/2;c.update(this.data.entries[a-1].content)},onClick:function(d){var b=this,a=b.data.currentEntry,c=Ext.fly(d.getTarget());if(c.hasCls(b.nextCls)){b.setCurrentEntry(a+1)}else{if(c.hasCls(b.prevCls)){b.setCurrentEntry(a-1)}else{if(c.hasCls(b.closeDetailsCls)){b.setMode("summary")}else{if(c.hasCls(b.previewCls)){b.setMode("detail",parseInt(c.getAttribute("data-index"),10))}}}}},refresh:function(){var a=this;if(!a.feedMgr){return}a.fireEvent("beforeload",a);a.feedMgr.setNumEntries(a.maxFeedEntries);a.feedMgr.load(function(b){a.setFeedData(b.feed);a.fireEvent("load",a)})},setCurrentEntry:function(a){this.setMode(this.mode,a)},setFeedData:function(b){var d=this,a=b.entries,c=a&&a.length||0,e=Ext.apply({numEntries:c,closeGlyph:d.wrapGlyph(d.closeDetailsGlyph),prevGlyph:d.wrapGlyph(d.prevGlyph),nextGlyph:d.wrapGlyph(d.nextGlyph),currentEntry:0},b);d.data=e;d.setMode(d.mode)},setMode:function(e,a){var b=this,c=b.data,d=(a===undefined)?c.currentEntry:a;b.tpl=b.lookupTpl(e+"Tpl");b.tpl.date=b.formatDate;b.mode=e;c.currentEntry=d;c.hasNext=d+1<c.numEntries;c.hasPrev=d>0;b.update(c);b.el.dom.scrollTop=0},wrapGlyph:function(c){var d=Ext._glyphFontFamily,b,a;if(typeof c==="string"){b=c.split("@");c=b[0];d=b[1]}a="&#"+c+";";if(d){a='<span style="font-family:'+d+'">'+a+"</span>"}return a},doDestroy:function(){Ext.destroy(this.tip);this.callParent()}});Ext.define("Ext.ux.dashboard.GoogleRssPart",{extend:"Ext.dashboard.Part",alias:"part.google-rss",requires:["Ext.window.MessageBox","Ext.ux.dashboard.GoogleRssView"],viewTemplate:{layout:"fit",items:{xclass:"Ext.ux.dashboard.GoogleRssView",feedUrl:"{feedUrl}"}},type:"google-rss",config:{suggestedFeed:"http://rss.slashdot.org/Slashdot/slashdot"},formTitleAdd:"Add RSS Feed",formTitleEdit:"Edit RSS Feed",formLabel:"RSS Feed URL",displayForm:function(a,b,g,d){var e=this,c=b?b.feedUrl:e.getSuggestedFeed(),f=a?e.formTitleEdit:e.formTitleAdd;Ext.Msg.prompt(f,e.formLabel,function(h,i){if(h==="ok"){g.call(d||e,{feedUrl:i})}},e,false,c)}});